/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public final class GenericRecipeUtils {
    private GenericRecipeUtils() {
    }

    @NotNull
    public static List<ITextComponent> calculateRestrictions(@NotNull CustomRecipe customRecipe) {
        ITextComponent researchName;
        ArrayList<ITextComponent> restrictions = new ArrayList<ITextComponent>();
        if (customRecipe.getMinBuildingLevel() == customRecipe.getMaxBuildingLevel()) {
            restrictions.add((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.jei.onelevelrestriction", new Object[]{customRecipe.getMinBuildingLevel()}));
        } else if (customRecipe.getMinBuildingLevel() > 1 || customRecipe.getMaxBuildingLevel() < 5) {
            restrictions.add((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.jei.levelrestriction", new Object[]{customRecipe.getMinBuildingLevel(), customRecipe.getMaxBuildingLevel()}));
        }
        if (customRecipe.getRequiredResearchId() != null) {
            researchName = GenericRecipeUtils.getResearchDisplayName(customRecipe.getRequiredResearchId());
            restrictions.add((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.jei.minresearch", new Object[]{researchName}));
        }
        if (customRecipe.getExcludedResearchId() != null) {
            researchName = GenericRecipeUtils.getResearchDisplayName(customRecipe.getExcludedResearchId());
            restrictions.add((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.jei.maxresearch", new Object[]{researchName}));
        }
        return restrictions;
    }

    @NotNull
    public static IGenericRecipe create(@NotNull CustomRecipe customRecipe, @NotNull IRecipeStorage storage) {
        List<ITextComponent> restrictions = GenericRecipeUtils.calculateRestrictions(customRecipe);
        return Objects.requireNonNull(GenericRecipe.of(storage, restrictions, customRecipe.getMinBuildingLevel()));
    }

    @NotNull
    public static IGenericRecipe create(@NotNull IRecipe<?> recipe) {
        IGenericRecipe original = Objects.requireNonNull(GenericRecipe.of(recipe));
        List<List<ItemStack>> inputs = GenericRecipeUtils.compact((NonNullList<Ingredient>)recipe.func_192400_c());
        return new GenericRecipe(original.getPrimaryOutput(), original.getAdditionalOutputs(), inputs, original.getGridSize(), original.getIntermediate(), original.getLootTable(), new ArrayList<ITextComponent>(), -1);
    }

    @NotNull
    private static ITextComponent getResearchDisplayName(@NotNull ResourceLocation researchId) {
        IGlobalResearchTree researchTree = IGlobalResearchTree.getInstance();
        IGlobalResearch research = researchTree.getResearch(researchId);
        if (research != null) {
            return research.getName();
        }
        Set<IGlobalResearch> researches = researchTree.getResearchForEffect(researchId);
        if (researches != null && !researches.isEmpty()) {
            return researches.iterator().next().getName();
        }
        return new StringTextComponent("???");
    }

    private static List<List<ItemStack>> compact(NonNullList<Ingredient> inputs) {
        HashMap<IngredientStacks, IngredientStacks> ingredients = new HashMap<IngredientStacks, IngredientStacks>();
        for (Ingredient ingredient : inputs) {
            IngredientStacks newIngredient;
            if (ingredient == Ingredient.field_193370_a || !(newIngredient = new IngredientStacks(ingredient)).getStacks().isEmpty() && newIngredient.getStacks().get(0).func_77973_b() == ModItems.buildTool.get()) continue;
            IngredientStacks existing = (IngredientStacks)ingredients.get(newIngredient);
            if (existing == null) {
                ingredients.put(newIngredient, newIngredient);
                continue;
            }
            existing.merge(newIngredient);
        }
        return (List)ingredients.values().stream().sorted(Comparator.reverseOrder()).map(IngredientStacks::getStacks).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }

    private static class IngredientStacks
    implements Comparable<IngredientStacks> {
        private final List<ItemStack> stacks;
        private final Set<Item> items;

        public IngredientStacks(Ingredient ingredient) {
            this.stacks = Collections.unmodifiableList(Arrays.stream(ingredient.func_193365_a()).filter(stack -> !stack.func_190926_b()).map(ItemStack::func_77946_l).collect(Collectors.toList()));
            this.items = this.stacks.stream().map(ItemStack::func_77973_b).collect(Collectors.toSet());
        }

        @NotNull
        public List<ItemStack> getStacks() {
            return this.stacks;
        }

        public int getCount() {
            return this.stacks.isEmpty() ? 0 : this.stacks.get(0).func_190916_E();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IngredientStacks that = (IngredientStacks)o;
            return this.items.equals(that.items);
        }

        public int hashCode() {
            return this.items.hashCode();
        }

        @Override
        public int compareTo(@NotNull IngredientStacks o) {
            int diff = this.getCount() - o.getCount();
            if (diff != 0) {
                return diff;
            }
            diff = this.stacks.size() - o.stacks.size();
            if (diff != 0) {
                return diff;
            }
            return this.hashCode() - o.hashCode();
        }

        public void merge(@NotNull IngredientStacks other) {
            for (int i = 0; i < this.stacks.size(); ++i) {
                this.stacks.get(i).func_190917_f(other.stacks.get(i).func_190916_E());
            }
        }

        public String toString() {
            return "IngredientStacks{stacks=" + this.stacks + ", items=" + this.items + '}';
        }
    }
}

